program SBTest;

uses
  crt, xSound;

var
  wav, wav2 : TWavData;

begin
  ClrScr;

  { Sound Blaster detection }
  if not xSBDetect then
    begin
        WriteLn('Sound Blaster not found!');
        Halt(1);
    end
    else
        WriteLn('Sound Blaster found at A', HexStr(sb_base, 3), ' I', sb_irq, ' D', sb_dma);

  { Sound Blaster initialization }
  xSBInit;

  { Set master volume (optional, default is full) }
  xSetMasterVolume(255);

  { Load WAV file (assuming "test.wav" exists) }
  xLoadSound(wav, 'test.wav');
  xLoadSound(wav2, 'franko4.wav');

  { Play single sound (without changing sampling rate) }
  Writeln('Playing sound...');
  xPlaySound(wav2, 5000);

  { Wait for any key press (to hear the sound) }
  Writeln('Press any key to continue...');
  ReadKey;

  { Play the same sound with auto-initialization and new sampling rate (optional) }
  xPlaySound(wav, 22050);  { Change to 22 kHz if desired }

  { Wait for any key press (to hear the sound) }
  Writeln('Press any key to continue...');
  ReadKey;

  xPlaySine(440, 5000); { Play a 440 Hz sine wave }

  { Wait for any key press }
  Writeln('Press any key to exit...');
  ReadKey;

  { Deinitialize Sound Blaster }
  xSBDeinit;

  { Free memory used by sounds }
  FreeMem(wav.data, wav.size);
  FreeMem(wav2.data, wav2.size);

  { Play a note on the PC speaker (example without SB) }
  while not KeyPressed do
  begin
    xPlayNote(C, 4, 1000);  { Play for 1000 ticks (approx. 1 second) }
    xUpdateSound;           { Update sound state }
    Delay(1000);            { Assuming one tick ≈ 1 ms for approx. 1 second }
    xPlayPause(500);        { Pause for 500 ticks (approx. 0.5 second) }
  end;
  ReadKey;  { Consume the pressed key }

  Writeln('End of program.');
end.